#ifndef CGEN2TAGDIALOG_H
#define CGEN2TAGDIALOG_H

#include <QDialog>
#include <ui_CGen2TagDialog.h>
#include "../../ui/ConfigDialog.h"

#include <QrfeReaderInterfaceGlobal>
#include <tag/QrfeGen2Tag>
#include <epc/EPC_Defines>

#include <QrfeProgressDialog>

class QStandardItemModel;
class QStandardItem;

class QrfeReaderInterface;
class QrfeTagManipulatorInterface;

class QrfeGen2Tag;

class CGen2ExplicitReadDialog;
class CGen2PassDialog;
class CGen2KillDialog;
class CGen2LockDialog;
class CGen2SetPasswordDialog;
class CGen2SetEPCDialog;
class CGen2StoreText;

class CGen2NxpG2iMConfigWord;
class CGen2NxpG2iLDialog;
class CGen2NxpG2iLConfigWord;
class CGen2NxpG2I2CDialog;
class CGen2NxpG2I2CConfigWord;
class CGen2NxpUcode7ConfigWord;
class CGen2NxpUcode8ConfigWord;
class CGen2NxpUcodeDNAConfigWord;

class CGen2AmsSL900aDialog;
class CGen2EM4325Dialog;

class CGen2TagDialog : public QDialog, ConfigDialog
{
    Q_OBJECT

public:
	CGen2TagDialog(QWidget *parent = 0);
    ~CGen2TagDialog();

private:
    int execPrivate ( );

public slots:
	int exec ( QrfeReaderInterface* ph, QString tagId, uint antennaId );

	virtual void done(int r);

	bool getTagInfos();

	void readMem();
	void setMem();
	void exportMem();

	void read();
	void setEPC();
	void lock();
	void setPassword();
	void killTag();
	void storeText();

	void nxpSetReadProtect();
    void nxpConfigWord();
	void nxpG2iLDemo();
	void nxpI2CDemo();

	void amsSL900ADemo();
	void em4325Demo();

private slots:
	void memBankChanged(int index);
	void itemChanged(QStandardItem*);

	void shrink();

signals:
	void easterKeyUnlocked();

private:
	bool getPassword(QByteArray& passwd);

	void clearMemory();
	void saveMemory(const QString& name, const QByteArray& mem);

private:
	QrfeReaderInterface* 			m_reader;
	QrfeGen2Tag*					m_tag;
	uint 							m_antennaId;

	QString 						m_memoryName;
	QByteArray						m_memory;
	QByteArray						m_memoryChangeFlags;
	QStandardItemModel*				m_memoryModel;
    bool 							m_readActive;

    QrfeProgressDialog*				m_progressBar;

	CGen2ExplicitReadDialog* 		m_explicitReadDialog;
	CGen2PassDialog* 				m_passwordDialog;
	CGen2KillDialog* 				m_killDialog;
	CGen2LockDialog* 				m_lockDialog;
	CGen2SetPasswordDialog* 		m_setPasswordDialog;
	CGen2SetEPCDialog* 				m_setEPCDialog;
	CGen2StoreText*					m_storeText;

	CGen2NxpG2iMConfigWord* 		m_nxpG2iMConfigWordDialog;
	CGen2NxpG2iLConfigWord* 		m_nxpG2iLConfigWordDialog;
	CGen2NxpG2iLDialog*				m_nxpG2iLDialog;
	CGen2NxpG2I2CConfigWord*		m_nxpI2CConfigWordDialog;
	CGen2NxpG2I2CDialog*			m_nxpG2I2CDialog;
    CGen2NxpUcode7ConfigWord*       m_nxpUcode7ConfigWordDialog;
    CGen2NxpUcode8ConfigWord*       m_nxpUcode8ConfigWordDialog;
    CGen2NxpUcodeDNAConfigWord*     m_nxpUcodeDNAConfigWordDialog;

	CGen2AmsSL900aDialog*			m_amsSL900ADemo;
	CGen2EM4325Dialog*				m_em4325ADemo;

    Ui::CGen2TagDialogClass ui;
};

#endif // CGEN2TAGDIALOG_H
